package jamezo97.clonecraft;

import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class Ray {
	
	double dzdx;
	double dxdz;
	
	double dydx;
	double dxdy;
	
	double dydz;
	double dzdy;
	
	double dy, dx, dz;
	
	double xTranslation;
	double yTranslation;
	double zTranslation;
	
	public Ray(Vec3 pos1, Vec3 pos2){
		xTranslation = pos1.xCoord;
		yTranslation = pos1.yCoord;
		zTranslation = pos1.zCoord;
		
		dx = pos2.xCoord - pos1.xCoord;
		dy = pos2.yCoord - pos1.yCoord;
		dz = pos2.zCoord - pos1.zCoord;
		
		dydx = dy / dx;
		dxdy = dx / dy;
		
		dxdz = dx / dz;
		dzdx = dz / dx;
		
		dydz = dy / dz;
		dzdy = dz / dy;
	}
	
	public double getXGivenZ(double zVal){
		return (zVal -  zTranslation) * dxdz + xTranslation;
	}
	
	public double getXGivenY(double yVal){
		return (yVal -  yTranslation) * dxdy + xTranslation;
	}
	
	public double getZGivenX(double xVal){
		return (xVal -  xTranslation) * dzdx + zTranslation;
	}
	
	public double getZGivenY(double yVal){
		return (yVal -  yTranslation) * dzdy + zTranslation;
	}
	
	public double getYGivenX(double xVal){
		return (xVal -  xTranslation) * dydx + yTranslation;
	}
	
	public double getYGivenZ(double zVal){
		return (zVal -  zTranslation) * dydz + yTranslation;
	}
	
	public boolean intersects(AxisAlignedBB box){
		double x, y, z;
		x = box.minX;
		y = getYGivenX(x);
		z = getZGivenX(x);
		if(isInside(box, x, y, z)){
			return true;
		}
		x = box.maxX;
		y = getYGivenX(x);
		z = getZGivenX(x);
		if(isInside(box, x, y, z)){
			return true;
		}
		y = box.minY;
		x = getXGivenY(y);
		z = getZGivenY(y);
		if(isInside(box, x, y, z)){
			return true;
		}
		y = box.maxY;
		x = getXGivenY(y);
		z = getZGivenY(y);
		if(isInside(box, x, y, z)){
			return true;
		}
		z = box.minZ;
		x = getXGivenZ(z);
		y = getYGivenZ(z);
		if(isInside(box, x, y, z)){
			return true;
		}
		z = box.maxZ;
		x = getXGivenZ(z);
		y = getYGivenZ(z);
		if(isInside(box, x, y, z)){
			return true;
		}
		return false;
	}
	
	public boolean isInside(AxisAlignedBB box, double x, double y, double z){
		if(x >= box.minX && x <= box.maxX && y >= box.minY && y <= box.maxY && z >= box.minZ && z <= box.maxZ){
			return true;
		}
		return false;
	}

}
